/*
 * Decompiled with CFR 0.152.
 */
package cis.common.digsig.signer.ui;

import java.security.cert.Certificate;
import java.security.cert.X509Certificate;

public class CertificateListItem {
    private String itemId;
    private Certificate certificate;

    CertificateListItem(String alias, Certificate certificate) {
        this.itemId = alias;
        this.certificate = certificate;
    }

    public Certificate getCertificate() {
        return this.certificate;
    }

    public String getItemId() {
        return this.itemId;
    }

    public String toString() {
        return this.itemId + " | " + this.formatIssuerForCarm();
    }

    private String formatIssuerForCarm() {
        if (this.certificate != null && this.certificate instanceof X509Certificate) {
            String issuerDn = ((X509Certificate)this.certificate).getIssuerDN().getName();
            int beginIndex = issuerDn.indexOf("O=");
            int endIndex = issuerDn.indexOf(",", beginIndex);
            String issuer = "";
            if (endIndex <= -1 || beginIndex <= -1) {
                return issuerDn;
            }
            issuer = issuerDn.substring(beginIndex, endIndex);
            beginIndex = issuerDn.indexOf("OU=");
            endIndex = issuerDn.indexOf(",", beginIndex);
            String ou = "";
            if (endIndex > -1 && beginIndex > -1) {
                ou = "(" + issuerDn.substring(beginIndex, endIndex) + ")";
            }
            return issuer + ou;
        }
        return this.certificate.getType();
    }

    public int hashCode() {
        int hash = 5;
        hash = 37 * hash + (this.itemId != null ? this.itemId.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CertificateListItem other = (CertificateListItem)obj;
        return this.itemId == null ? other.itemId == null : this.itemId.equals(other.itemId);
    }
}

